/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class PdPaymentDto extends BaseDto {

	private static final long serialVersionUID = 1812427511435550686L;
	
	// tB[h
	protected String kCode              = "";	// ЈR[h
	protected Date   calcDate               ;	// vZN
	protected Date   payday                 ;	// ^x
	protected String calcStatus         = "";	// vZXe[^X
	protected String kName              = "";	// Ј
	protected String stationCode        = "";	// R[h
	protected String positionCode       = "";	// EʃR[h
	protected String employmentType     = "";	// ٗp敪
	protected int    presence           = 0 ;	// oΓ
	protected int    workOnHoliday      = 0 ;	// xoΓ
	protected int    particularHoliday  = 0 ;	// ʋxɓ
	protected int    paidHoliday        = 0 ;	// Lxɓ
	protected int    absence            = 0 ;	// Γ
	protected int    paidHolidayRest    = 0 ;	// Lc
	protected float  paymentHours       = 0 ;	// 
	protected int    arriveLate         = 0 ;	// x
	protected float  effortTime         = 0 ;	// ʁAcƎ
	protected int    effortAllowance    = 0 ;	// ʁAcƎ蓖
	protected float  lateNight          = 0 ;	// [鎞
	protected int    lateNightAllowance = 0 ;	// [蓖
	protected float  overLate           = 0 ;	// [cƎ
	protected int    overLateAllowance  = 0 ;	// [cƎ蓖
	protected float  holidayTime        = 0 ;	// x
	protected int    holidayAllowance   = 0 ;	// x蓖
	protected float  attendance_13      = 0 ;	// ΑӍ13
	protected float  attendance_14      = 0 ;	// ΑӍ14
	protected int    institutionalAbs   = 0 ;	// xΓ
	protected int    otherAttendance    = 0 ;	// ̑Αӓ
	protected int    basicSalary        = 0 ;	// {
	protected int    ability1Allowance  = 0 ;	// E\蓖1
	protected int    ability2Allowance  = 0 ;	// E\蓖2
	protected int    familyAllowance    = 0 ;	// }{蓖
	protected int    allowance_05       = 0 ;	// x05
	protected int    allowance_06       = 0 ;	// x06
	protected int    cutForMissing      = 0 ;	// FΌz
	protected int    cutForShort        = 0 ;	// Ezo
	protected int    allowance_09       = 0 ;	// x09
	protected int    allowance_10       = 0 ;	// x10
	protected int    allowance_11       = 0 ;	// x11
	protected int    allowance_12       = 0 ;	// x12
	protected int    allowance_13       = 0 ;	// x13
	protected int    dateAllowance      = 0 ;	// t蓖
	protected int    allowance_15       = 0 ;	// x15
	protected int    allowance_16       = 0 ;	// x16
	protected int    allowance_17       = 0 ;	// x17
	protected int    commutation        = 0 ;	// ʋΔ
	protected int    commutationTax     = 0 ;	// ېŒʋΔ
	protected int    overtimeAllowance  = 0 ;	// E[Ex
	protected int    cutFromBasic       = 0 ;	// z
	protected int    healthInsurance    = 0 ;	// Nی
	protected int    pensionInsurance   = 0 ;	// Nی
	protected int    pensionFund        = 0 ;	// N
	protected int    employeeInsurance  = 0 ;	// ٗpی
	protected int    incomeTax          = 0 ;	// 
	protected int    residenceTax       = 0 ;	// Z
	protected int    nursingInsurance   = 0 ;	// ی
	protected int    deduction_08       = 0 ;	// T08
	protected int    deduction_09       = 0 ;	// T09
	protected int    deduction_10       = 0 ;	// T10
	protected int    deduction_11       = 0 ;	// T11
	protected int    deduction_12       = 0 ;	// T12
	protected int    deduction_13       = 0 ;	// T13
	protected int    deduction_14       = 0 ;	// T14
	protected int    deduction_15       = 0 ;	// T15
	protected int    deduction_16       = 0 ;	// T16
	protected int    deduction_17       = 0 ;	// T17
	protected int    deduction_18       = 0 ;	// T18
	protected int    deduction_19       = 0 ;	// T19
	protected int    deduction_20       = 0 ;	// T20
	protected int    allowanceTotal     = 0 ;	// xz
	protected int    deductionTotal     = 0 ;	// Tz
	protected int    paymentTotal       = 0 ;	// xz
	protected int    bank1PayAmount     = 0 ;	// s1Uz
	protected int    bank2PayAmount     = 0 ;	// s2Uz
	protected int    cashPayAmount      = 0 ;	// xz
	protected int    dependentCount     = 0 ;	// }{̐
	protected int    amountToTaxation   = 0 ;	// ېőΏۊz
	protected int    amountToSocIns     = 0 ;	// ЉیΏۊz
	
	/**
	 * RXgN^
	 */
	public PdPaymentDto(){
		super();
	}
	
	/**
	 * xz擾
	 */
	public int calcAllowanceTotal() {
		return basicSalary       +
				ability1Allowance +
				ability2Allowance +
				familyAllowance   +
				allowance_05      +
				allowance_06      +
				cutForMissing     +
				cutForShort       +
				allowance_09      +
				allowance_10      +
				allowance_11      +
				allowance_12      +
				allowance_13      +
				dateAllowance     +
				allowance_15      +
				allowance_16      +
				allowance_17      +
				commutation       +
				overtimeAllowance +
				cutFromBasic      ;
	}
	
	/**
	 * Tz擾
	 */
	public int calcDeductionTotal() {
		return calcSocialInsurance() +
				incomeTax             +
				residenceTax          +
				calcGenaralDeduction(); 
	}
	
	/**
	 * Tz擾
	 */
	public int calcGenaralDeduction() {
		return deduction_08 +
				deduction_09 +
				deduction_10 +
				deduction_11 +
				deduction_12 +
				deduction_13 +
				deduction_14 +
				deduction_15 +
				deduction_16 +
				deduction_17 +
				deduction_18 +
				deduction_19 +
				deduction_20 ;
	}
	
	/**
	 * Љی擾
	 * @return Љی(v)
	 */
	public int calcSocialInsurance() {
		return 	healthInsurance   +
				pensionInsurance  +
				pensionFund       +
				employeeInsurance +
				nursingInsurance  ;
	}
	
	/**
	 * ېŒʋΔ擾
	 * @return Љی(v)
	 */
	public int getCommutationFree() {
		int commutationFree = commutation - commutationTax;
		return 	commutationFree < 0 ? 0 : commutationFree;
	}
	
	/**
	 * ېŊz擾
	 * @return ېŊz
	 */
	public int getTaxExempt() {
		int taxExempt = allowanceTotal- calcSocialInsurance() - amountToTaxation ;
		// xz-Љیv-ېőΏۊz
		if (taxExempt < 0) {
			taxExempt = 0;
		}
		return taxExempt;
	}
	
	/**
	 * ېőΏۊz(ŌvZO)
	 * @return ېŊz
	 */
	public int getTaxation() {
		int taxation = allowanceTotal - getTaxExempt();
		if (taxation < 0) {
			taxation = 0;
		}
		return taxation;
	}

	
	// ANZT\bh
	public String getKCode             () { return kCode                 ; }	// ЈR[h
	public Date   getCalcDate          () { return getDateField(calcDate); }	// vZN
	public Date   getPayday            () { return getDateField(payday  ); }	// ^x
	public String getCalcStatus        () { return calcStatus            ; }	// vZXe[^X
	public String getKName             () { return kName                 ; }	// Ј
	public String getStationCode       () { return stationCode           ; }	// R[h
	public String getPositionCode      () { return positionCode          ; }	// EʃR[h
	public String getEmploymentType    () { return employmentType        ; }	// ٗp敪
	public int    getPresence          () { return presence              ; }	// oΓ
	public int    getWorkOnHoliday     () { return workOnHoliday         ; }	// xoΓ
	public int    getParticularHoliday () { return particularHoliday     ; }	// ʋxɓ
	public int    getPaidHoliday       () { return paidHoliday           ; }	// Lxɓ
	public int    getAbsence           () { return absence               ; }	// Γ
	public int    getPaidHolidayRest   () { return paidHolidayRest       ; }	// Lc
	public float  getPaymentHours      () { return paymentHours          ; }	// 
	public int    getArriveLate        () { return arriveLate            ; }	// x
	public float  getEffortTime        () { return effortTime            ; }	// ʁAcƎ
	public int    getEffortAllowance   () { return effortAllowance       ; }	// ʁAcƎ蓖
	public float  getLateNight         () { return lateNight             ; }	// [鎞
	public int    getLateNightAllowance() { return lateNightAllowance    ; }	// [蓖
	public float  getOverLate          () { return overLate              ; }	// [cƎ
	public int    getOverLateAllowance () { return overLateAllowance     ; }	// [cƎ蓖
	public float  getHolidayTime       () { return holidayTime           ; }	// x
	public int    getHolidayAllowance  () { return holidayAllowance      ; }	// x蓖
	public float  getAttendance_13     () { return attendance_13         ; }	// ΑӍ13
	public float  getAttendance_14     () { return attendance_14         ; }	// ΑӍ14
	public int    getInstitutionalAbs  () { return institutionalAbs      ; }	// xΓ
	public int    getOtherAttendance   () { return otherAttendance       ; }	// ̑Αӓ
	public int    getBasicSalary       () { return basicSalary           ; }	// {
	public int    getAbility1Allowance () { return ability1Allowance     ; }	// E\蓖1
	public int    getAbility2Allowance () { return ability2Allowance     ; }	// E\蓖2
	public int    getFamilyAllowance   () { return familyAllowance       ; }	// }{蓖
	public int    getAllowance_05      () { return allowance_05          ; }	// x05
	public int    getAllowance_06      () { return allowance_06          ; }	// x06
	public int    getCutForMissing     () { return cutForMissing         ; }	// FΌz
	public int    getCutForShort       () { return cutForShort           ; }	// Ezo
	public int    getAllowance_09      () { return allowance_09          ; }	// x09
	public int    getAllowance_10      () { return allowance_10          ; }	// x10
	public int    getAllowance_11      () { return allowance_11          ; }	// x11
	public int    getAllowance_12      () { return allowance_12          ; }	// x12
	public int    getAllowance_13      () { return allowance_13          ; }	// x13
	public int    getDateAllowance     () { return dateAllowance         ; }	// t蓖
	public int    getAllowance_15      () { return allowance_15          ; }	// x15
	public int    getAllowance_16      () { return allowance_16          ; }	// x16
	public int    getAllowance_17      () { return allowance_17          ; }	// x17
	public int    getCommutation       () { return commutation           ; }	// ʋΔ
	public int    getCommutationTax    () { return commutationTax        ; }	// ېŒʋΔ
	public int    getOvertimeAllowance () { return overtimeAllowance     ; }	// E[Ex
	public int    getCutFromBasic      () { return cutFromBasic          ; }	// z
	public int    getHealthInsurance   () { return healthInsurance       ; }	// Nی
	public int    getPensionInsurance  () { return pensionInsurance      ; }	// Nی
	public int    getPensionFund       () { return pensionFund           ; }	// N
	public int    getEmployeeInsurance () { return employeeInsurance     ; }	// ٗpی
	public int    getIncomeTax         () { return incomeTax             ; }	// 
	public int    getResidenceTax      () { return residenceTax          ; }	// Z
	public int    getNursingInsurance  () { return nursingInsurance      ; }	// ی
	public int    getDeduction_08      () { return deduction_08          ; }	// T08
	public int    getDeduction_09      () { return deduction_09          ; }	// T09
	public int    getDeduction_10      () { return deduction_10          ; }	// T10
	public int    getDeduction_11      () { return deduction_11          ; }	// T11
	public int    getDeduction_12      () { return deduction_12          ; }	// T12
	public int    getDeduction_13      () { return deduction_13          ; }	// T13
	public int    getDeduction_14      () { return deduction_14          ; }	// T14
	public int    getDeduction_15      () { return deduction_15          ; }	// T15
	public int    getDeduction_16      () { return deduction_16          ; }	// T16
	public int    getDeduction_17      () { return deduction_17          ; }	// T17
	public int    getDeduction_18      () { return deduction_18          ; }	// T18
	public int    getDeduction_19      () { return deduction_19          ; }	// T19
	public int    getDeduction_20      () { return deduction_20          ; }	// T20
	public int    getAllowanceTotal    () { return allowanceTotal        ; }	// xz
	public int    getDeductionTotal    () { return deductionTotal        ; }	// Tz
	public int    getPaymentTotal      () { return paymentTotal          ; }	// xz
	public int    getBank1PayAmount    () { return bank1PayAmount        ; }	// s1Uz
	public int    getBank2PayAmount    () { return bank2PayAmount        ; }	// s2Uz
	public int    getCashPayAmount     () { return cashPayAmount         ; }	// xz
	public int    getDependentCount    () { return dependentCount        ; }	// }{̐
	public int    getAmountToTaxation  () { return amountToTaxation      ; }	// ېőΏۊz
	public int    getAmountToSocIns    () { return amountToSocIns        ; }	// ЉیΏۊz

	public void setKCode             (String kCode             ) { this.kCode              = kCode                 ; }	// ЈR[h
	public void setCalcDate          (Date   calcDate          ) { this.calcDate           = getDateField(calcDate); }	// vZN
	public void setPayday            (Date   payday            ) { this.payday             = getDateField(payday)  ; }	// ^x
	public void setCalcStatus        (String calcStatus        ) { this.calcStatus         = calcStatus            ; }	// vZXe[^X
	public void setKName             (String kName             ) { this.kName              = kName                 ; }	// Ј
	public void setStationCode       (String stationCode       ) { this.stationCode        = stationCode           ; }	// R[h
	public void setPositionCode      (String positionCode      ) { this.positionCode       = positionCode          ; }	// EʃR[h
	public void setEmploymentType    (String employmentType    ) { this.employmentType     = employmentType        ; }	// ٗp敪
	public void setPresence          (int    presence          ) { this.presence           = presence              ; }	// oΓ
	public void setWorkOnHoliday     (int    workOnHoliday     ) { this.workOnHoliday      = workOnHoliday         ; }	// xoΓ
	public void setParticularHoliday (int    particularHoliday ) { this.particularHoliday  = particularHoliday     ; }	// ʋxɓ
	public void setPaidHoliday       (int    paidHoliday       ) { this.paidHoliday        = paidHoliday           ; }	// Lxɓ
	public void setAbsence           (int    absence           ) { this.absence            = absence               ; }	// Γ
	public void setPaidHolidayRest   (int    paidHolidayRest   ) { this.paidHolidayRest    = paidHolidayRest       ; }	// Lc
	public void setPaymentHours      (float  paymentHours      ) { this.paymentHours       = paymentHours          ; }	// 
	public void setArriveLate        (int    arriveLate        ) { this.arriveLate         = arriveLate            ; }	// x
	public void setEffortTime        (float  effortTime        ) { this.effortTime         = effortTime            ; }	// ʁAcƎ
	public void setEffortAllowance   (int    effortAllowance   ) { this.effortAllowance    = effortAllowance       ; }	// ʁAcƎ蓖
	public void setLateNight         (float  lateNight         ) { this.lateNight          = lateNight             ; }	// [鎞
	public void setLateNightAllowance(int    lateNightAllowance) { this.lateNightAllowance = lateNightAllowance    ; }	// [蓖
	public void setOverLate          (float  overLate          ) { this.overLate           = overLate              ; }	// [cƎ
	public void setOverLateAllowance (int    overLateAllowance ) { this.overLateAllowance  = overLateAllowance     ; }	// [cƎ蓖
	public void setHolidayTime       (float  holidayTime       ) { this.holidayTime        = holidayTime           ; }	// x
	public void setHolidayAllowance  (int    holidayAllowance  ) { this.holidayAllowance   = holidayAllowance      ; }	// x蓖
	public void setAttendance_13     (float  attendance_13     ) { this.attendance_13      = attendance_13         ; }	// ΑӍ13
	public void setAttendance_14     (float  attendance_14     ) { this.attendance_14      = attendance_14         ; }	// ΑӍ14
	public void setInstitutionalAbs  (int    institutionalAbs  ) { this.institutionalAbs   = institutionalAbs      ; }	// xΓ
	public void setOtherAttendance   (int    otherAttendance   ) { this.otherAttendance    = otherAttendance       ; }	// ̑Αӓ
	public void setBasicSalary       (int    basicSalary       ) { this.basicSalary        = basicSalary           ; }	// {
	public void setAbility1Allowance (int    ability1Allowance ) { this.ability1Allowance  = ability1Allowance     ; }	// E\蓖1
	public void setAbility2Allowance (int    ability2Allowance ) { this.ability2Allowance  = ability2Allowance     ; }	// E\蓖2
	public void setFamilyAllowance   (int    familyAllowance   ) { this.familyAllowance    = familyAllowance       ; }	// }{蓖
	public void setAllowance_05      (int    allowance_05      ) { this.allowance_05       = allowance_05          ; }	// x05
	public void setAllowance_06      (int    allowance_06      ) { this.allowance_06       = allowance_06          ; }	// x06
	public void setCutForMissing     (int    cutForMissing     ) { this.cutForMissing      = cutForMissing         ; }	// FΌz
	public void setCutForShort       (int    cutForShort       ) { this.cutForShort        = cutForShort           ; }	// Ezo
	public void setAllowance_09      (int    allowance_09      ) { this.allowance_09       = allowance_09          ; }	// x09
	public void setAllowance_10      (int    allowance_10      ) { this.allowance_10       = allowance_10          ; }	// x10
	public void setAllowance_11      (int    allowance_11      ) { this.allowance_11       = allowance_11          ; }	// x11
	public void setAllowance_12      (int    allowance_12      ) { this.allowance_12       = allowance_12          ; }	// x12
	public void setAllowance_13      (int    allowance_13      ) { this.allowance_13       = allowance_13          ; }	// x13
	public void setDateAllowance     (int    dateAllowance     ) { this.dateAllowance      = dateAllowance         ; }	// t蓖
	public void setAllowance_15      (int    allowance_15      ) { this.allowance_15       = allowance_15          ; }	// x15
	public void setAllowance_16      (int    allowance_16      ) { this.allowance_16       = allowance_16          ; }	// x16
	public void setAllowance_17      (int    allowance_17      ) { this.allowance_17       = allowance_17          ; }	// x17
	public void setCommutation       (int    commutation       ) { this.commutation        = commutation           ; }	// ʋΔ
	public void setCommutationTax    (int    commutationTax    ) { this.commutationTax     = commutationTax        ; }	// ېŒʋΔ
	public void setOvertimeAllowance (int    overtimeAllowance ) { this.overtimeAllowance  = overtimeAllowance     ; }	// E[Ex
	public void setCutFromBasic      (int    cutFromBasic      ) { this.cutFromBasic       = cutFromBasic          ; }	// z
	public void setHealthInsurance   (int    healthInsurance   ) { this.healthInsurance    = healthInsurance       ; }	// Nی
	public void setPensionInsurance  (int    pensionInsurance  ) { this.pensionInsurance   = pensionInsurance      ; }	// Nی
	public void setPensionFund       (int    pensionFund       ) { this.pensionFund        = pensionFund           ; }	// N
	public void setEmployeeInsurance (int    employeeInsurance ) { this.employeeInsurance  = employeeInsurance     ; }	// ٗpی
	public void setIncomeTax         (int    incomeTax         ) { this.incomeTax          = incomeTax             ; }	// 
	public void setResidenceTax      (int    residenceTax      ) { this.residenceTax       = residenceTax          ; }	// Z
	public void setNursingInsurance  (int    nursingInsurance  ) { this.nursingInsurance   = nursingInsurance      ; }	// ی
	public void setDeduction_08      (int    deduction_08      ) { this.deduction_08       = deduction_08          ; }	// T08
	public void setDeduction_09      (int    deduction_09      ) { this.deduction_09       = deduction_09          ; }	// T09
	public void setDeduction_10      (int    deduction_10      ) { this.deduction_10       = deduction_10          ; }	// T10
	public void setDeduction_11      (int    deduction_11      ) { this.deduction_11       = deduction_11          ; }	// T11
	public void setDeduction_12      (int    deduction_12      ) { this.deduction_12       = deduction_12          ; }	// T12
	public void setDeduction_13      (int    deduction_13      ) { this.deduction_13       = deduction_13          ; }	// T13
	public void setDeduction_14      (int    deduction_14      ) { this.deduction_14       = deduction_14          ; }	// T14
	public void setDeduction_15      (int    deduction_15      ) { this.deduction_15       = deduction_15          ; }	// T15
	public void setDeduction_16      (int    deduction_16      ) { this.deduction_16       = deduction_16          ; }	// T16
	public void setDeduction_17      (int    deduction_17      ) { this.deduction_17       = deduction_17          ; }	// T17
	public void setDeduction_18      (int    deduction_18      ) { this.deduction_18       = deduction_18          ; }	// T18
	public void setDeduction_19      (int    deduction_19      ) { this.deduction_19       = deduction_19          ; }	// T19
	public void setDeduction_20      (int    deduction_20      ) { this.deduction_20       = deduction_20          ; }	// T20
	public void setAllowanceTotal    (int    allowanceTotal    ) { this.allowanceTotal     = allowanceTotal        ; }	// xz
	public void setDeductionTotal    (int    deductionTotal    ) { this.deductionTotal     = deductionTotal        ; }	// Tz
	public void setPaymentTotal      (int    paymentTotal      ) { this.paymentTotal       = paymentTotal          ; }	// xz
	public void setBank1PayAmount    (int    bank1PayAmount    ) { this.bank1PayAmount     = bank1PayAmount        ; }	// s1Uz
	public void setBank2PayAmount    (int    bank2PayAmount    ) { this.bank2PayAmount     = bank2PayAmount        ; }	// s2Uz
	public void setCashPayAmount     (int    cashPayAmount     ) { this.cashPayAmount      = cashPayAmount         ; }	// xz
	public void setDependentCount    (int    dependentCount    ) { this.dependentCount     = dependentCount        ; }	// }{̐
	public void setAmountToTaxation  (int    amountToTaxation  ) { this.amountToTaxation   = amountToTaxation      ; }	// ېőΏۊz
	public void setAmountToSocIns    (int    amountToSocIns    ) { this.amountToSocIns     = amountToSocIns        ; }	// ЉیΏۊz
	
}
